<?php
session_start();

// الاتصال بقاعدة البيانات
include('admin_user_pass.php');

// إنشاء اتصال بقاعدة البيانات
$conn = new mysqli($servername, $username, $password, $dbname);
date_default_timezone_set('Asia/Riyadh');

// التحقق من وجود خطأ في الاتصال بقاعدة البيانات
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// التحقق من تقديم طلب مسح البيانات
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_data'])) {
    $delete_sql = "DELETE FROM clicks";
    if ($conn->query($delete_sql) === TRUE) {
        // تخزين رسالة نجاح في الجلسة
        $_SESSION['delete_success'] = 'تم مسح جميع البيانات بنجاح.';
    } else {
        echo "<p style='text-align: center; color: red;'>حدث خطأ أثناء مسح البيانات: " . $conn->error . "</p>";
    }
    // إعادة تحميل الصفحة بعد عملية المسح
    header('Location: visits.php');
    exit;
}

// قيم الإدخال الافتراضية
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

// استعلام SQL لجلب البيانات بناءً على الفترة الزمنية (تاريخ فقط)
$sql = "
    SELECT 
        DATE(visit_time) AS visit_date, 
        COUNT(*) AS visit_count
    FROM page_visits
";
if ($start_date && $end_date) {
    $sql .= " WHERE DATE(visit_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $sql .= " WHERE DATE(visit_time) >= '$start_date'";
} elseif ($end_date) {
    $sql .= " WHERE DATE(visit_time) <= '$end_date'";
}

$sql .= " GROUP BY visit_date ORDER BY visit_date ASC";
$result = $conn->query($sql);

// استعلام لحساب المجموع الكلي للزيارات
$sql_total = "
    SELECT COUNT(*) AS total_visits 
    FROM page_visits
";
if ($start_date && $end_date) {
    $sql_total .= " WHERE DATE(visit_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $sql_total .= " WHERE DATE(visit_time) >= '$start_date'";
} elseif ($end_date) {
    $sql_total .= " WHERE DATE(visit_time) <= '$end_date'";
}
$result_total = $conn->query($sql_total);
$total_visits = $result_total->fetch_assoc()['total_visits'] ?? 0;

// استعلام cURL للحصول على محتوى title من الموقع الآخر
$url = $_SERVER['REQUEST_SCHEME'] . "://" . $_SERVER['HTTP_HOST'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
curl_setopt($ch, CURLOPT_HTTPHEADER, ["Accept-Language: ar"]);

$response = curl_exec($ch);
$curlError = curl_error($ch);
curl_close($ch);

if ($response === false) {
    echo "خطأ في جلب البيانات من الموقع: $url<br>cURL Error: $curlError<br>";
    exit;
}

if (strpos($response, "\x1f\x8b\x08") === 0) {
    $response = gzdecode($response);
}

$dom = new DOMDocument();
libxml_use_internal_errors(true);
$dom->loadHTML($response);
libxml_clear_errors();

$xpath = new DOMXPath($dom);
$titleNodes = $xpath->query("//title");
$titleContent = $titleNodes->length > 0 ? $titleNodes->item(0)->nodeValue : "";

// استعلام لاستخراج أول وآخر زيارة بناءً على التواريخ المفلترة
$first_filtered_visit_sql = "
    SELECT MIN(visit_time) AS first_visit 
    FROM page_visits
";
if ($start_date && $end_date) {
    $first_filtered_visit_sql .= " WHERE DATE(visit_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $first_filtered_visit_sql .= " WHERE DATE(visit_time) >= '$start_date'";
} elseif ($end_date) {
    $first_filtered_visit_sql .= " WHERE DATE(visit_time) <= '$end_date'";
}

$last_filtered_visit_sql = "
    SELECT MAX(visit_time) AS last_visit 
    FROM page_visits
";
if ($start_date && $end_date) {
    $last_filtered_visit_sql .= " WHERE DATE(visit_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $last_filtered_visit_sql .= " WHERE DATE(visit_time) >= '$start_date'";
} elseif ($end_date) {
    $last_filtered_visit_sql .= " WHERE DATE(visit_time) <= '$end_date'";
}

// تنفيذ الاستعلامات فقط إذا كانت التواريخ غير فارغة
if ($start_date || $end_date) {
    $first_filtered_visit_result = $conn->query($first_filtered_visit_sql);
    $last_filtered_visit_result = $conn->query($last_filtered_visit_sql);

    // استخراج التاريخ فقط
    $first_visit = $first_filtered_visit_result->fetch_assoc()['first_visit'] ?? '';
    $last_visit = $last_filtered_visit_result->fetch_assoc()['last_visit'] ?? '';

    // تحويل التاريخ إلى الصيغة المطلوبة (YYYY-MM-DD)
    $first_visit_date = $first_visit ? date('Y-m-d', strtotime($first_visit)) : 'غير موجود';
    $last_visit_date = $last_visit ? date('Y-m-d', strtotime($last_visit)) : 'غير موجود';
}

// التحقق من تقديم طلب توليد PDF
// التحقق من تقديم طلب توليد PDF
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['generate_pdf'])) {
    // إذا لم يتم تعيين التواريخ، جلب أول وآخر زيارة من قاعدة البيانات
    if (empty($first_visit_date) || empty($last_visit_date)) {
        // استعلام لجلب أول زيارة من قاعدة البيانات
        $first_visit_sql = "SELECT MIN(visit_time) AS first_visit FROM page_visits";
        $first_visit_result = $conn->query($first_visit_sql);
        $first_visit = $first_visit_result->fetch_assoc()['first_visit'] ?? null;
        $first_visit_date = $first_visit ? date('Y-m-d', strtotime($first_visit)) : 'غير متوفر';

        // استعلام لجلب آخر زيارة من قاعدة البيانات
        $last_visit_sql = "SELECT MAX(visit_time) AS last_visit FROM page_visits";
        $last_visit_result = $conn->query($last_visit_sql);
        $last_visit = $last_visit_result->fetch_assoc()['last_visit'] ?? null;
        $last_visit_date = $last_visit ? date('Y-m-d', strtotime($last_visit)) : 'غير متوفر';
    }

    ob_clean();
    flush();

    require_once('tcpdf/tcpdf.php');

    $pdf = new TCPDF();
    $pdf->SetFont('aealarabiya', '', 12);
    $pdf->SetRTL(true);
    $pdf->SetMargins(10, 20, 10);
    $pdf->AddPage();

    $pdf->SetFont('aealarabiya', 'B', 18);
    $pdf->Cell(0, 10, 'شركة انتشر', 0, 1, 'C');
    $pdf->SetFont('aealarabiya', 'B', 16);
    $pdf->Cell(0, 10, 'تقرير مفصل عن الزيارات للموقع', 0, 1, 'C');
    $pdf->Ln(10);
    $pdf->SetFont('aealarabiya', 'B', 14);
    $pdf->Cell(0, 10, $titleContent, 0, 1, 'C');
    $pdf->Ln(10);

    // عرض تاريخ أول وآخر زيارة بناءً على نتائج قاعدة البيانات
    $pdf->SetFont('aealarabiya', 'B', 12);
    $pdf->Cell(0, 10, "تاريخ أول زيارة: $first_visit_date", 0, 1, 'C');
    $pdf->Cell(0, 10, "تاريخ آخر زيارة: $last_visit_date", 0, 1, 'C');
    $pdf->Ln(10);

    // عرض البيانات في التقرير
    $pdf->SetTextColor(255, 255, 255);
    $pdf->SetFillColor(0, 102, 204);
    $pdf->Cell(90, 10, 'التاريخ', 1, 0, 'C', 1);
    $pdf->Cell(90, 10, 'عدد الزيارات', 1, 1, 'C', 1);

    $pdf->SetTextColor(0, 0, 0);
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $pdf->Cell(90, 10, $row['visit_date'], 1, 0, 'C');
            $pdf->Cell(90, 10, $row['visit_count'], 1, 1, 'C');
        }
    } else {
        $pdf->Cell(180, 10, 'لا يوجد بيانات', 1, 1, 'C');
    }

    $pdf->Ln(10);
    $pdf->SetFont('aealarabiya', 'B', 12);
    $pdf->SetTextColor(255, 0, 0);
    $pdf->Cell(0, 10, 'إجمالي الزيارات: ' . $total_visits, 0, 1, 'C');

    $image_path = 'image/logo-w.png';
    $pdf->SetY(-100);
    $pdf->Image($image_path, ($pdf->getPageWidth() - 50) / 2, $pdf->GetY(), 50, 0, 'PNG');

    $pdf->Output('report.pdf', 'I');
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إحصائيات الزوار</title>
    <link rel="stylesheet" href="css/styles.css">
    <style>
        /* إضافة بعض الأنماط للزر عند تعطيله */
        button:disabled {
            background-color: #ccc;
            cursor: not-allowed;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>إحصائيات الزوار</h1>

        <form method="get">
            <label for="start_date">من:</label>
            <input type="date" name="start_date" id="start_date" value="<?php echo htmlspecialchars($start_date ?: $first_visit_date); ?>">
            <label for="end_date">إلى:</label>
            <input type="date" name="end_date" id="end_date" value="<?php echo htmlspecialchars($end_date ?: $last_visit_date); ?>">
            
            <button type="submit" id="filter-btn" disabled>فلترة</button>
        </form>

        <!-- زر توليد تقرير PDF -->
        <form method="post">
            <button type="submit" id="generate-pdf-btn" name="generate_pdf" disabled>توليد تقرير PDF</button>
            <button type="submit" name="delete_data">مسح البيانات</button>
        </form>

        <script>
            // الجافا سكربت لتفعيل الأزرار عند تحديد التاريخين
            document.addEventListener('DOMContentLoaded', function () {
                const startDateInput = document.getElementById('start_date');
                const endDateInput = document.getElementById('end_date');
                const filterButton = document.getElementById('filter-btn');
                const generatePdfButton = document.getElementById('generate-pdf-btn');

                function checkDates() {
                    // تفعيل الأزرار إذا كانت التواريخ موجودة
                    if (startDateInput.value && endDateInput.value) {
                        filterButton.disabled = false;
                        generatePdfButton.disabled = false;  // تفعيل زر توليد PDF
                    } else {
                        filterButton.disabled = true;
                        generatePdfButton.disabled = true;  // تعطيل زر توليد PDF
                    }
                }

                startDateInput.addEventListener('change', checkDates);
                endDateInput.addEventListener('change', checkDates);

                // تحقق عند تحميل الصفحة
                checkDates();
            });
        </script>

        <p><strong><?php echo htmlspecialchars($titleContent); ?></strong></p>

        <table>
            <thead>
                <tr>
                    <th>التاريخ</th>
                    <th>عدد الزيارات</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        $visit_date = htmlspecialchars($row['visit_date']);
                        echo "<tr><td><a href='visit_details.php?visit_date=$visit_date'>$visit_date</a></td><td>" . htmlspecialchars($row['visit_count']) . "</td></tr>";
                    }
                } else {
                    echo "<tr><td colspan='2'>لا توجد زيارات</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <p><strong>إجمالي الزيارات: <?php echo $total_visits; ?></strong></p>
    </div>
    <script>
    // تحقق من وجود رسالة في الجلسة لعرض رسالة JavaScript
    <?php if (isset($_SESSION['delete_success'])): ?>
        alert('<?php echo $_SESSION['delete_success']; ?>');
        // مسح الرسالة بعد عرضها لمنع تكرارها في المرات القادمة
        <?php unset($_SESSION['delete_success']); ?>
    <?php endif; ?>
</script>
</body>
</html>

<?php $conn->close(); ?>