<?php
// الاتصال بقاعدة البيانات
include('admin_user_pass.php');
$conn = new mysqli($servername, $username, $password, $dbname);

// التحقق من وجود خطأ في الاتصال بقاعدة البيانات
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// الحصول على التاريخ من الرابط
$visit_date = isset($_GET['visit_date']) ? $_GET['visit_date'] : '';

// استعلام لجلب التفاصيل بناءً على التاريخ المحدد
$sql = "SELECT visit_time FROM page_visits WHERE DATE(visit_time) = '$visit_date' ORDER BY visit_time ASC";
$result = $conn->query($sql);

// استعلام لحساب المجموع
$sql_count = "SELECT COUNT(*) AS visit_count FROM page_visits WHERE DATE(visit_time) = '$visit_date'";
$count_result = $conn->query($sql_count);
$total_visits = $count_result->fetch_assoc()['visit_count'];
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تفاصيل الزيارة - <?php echo htmlspecialchars($visit_date); ?></title>
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
    <div class="container">
        <h1>تفاصيل الزيارة بتاريخ <?php echo htmlspecialchars($visit_date); ?></h1>

        <?php
        if ($result->num_rows > 0) {
            echo "<table><thead><tr><th>الوقت</th></tr></thead><tbody>";
            while ($row = $result->fetch_assoc()) {
                $visit_time = htmlspecialchars($row['visit_time']);
                echo "<tr><td>$visit_time</td></tr>";
            }
            echo "<tr><td><strong>مجموع الزيارات: $total_visits</strong></td></tr>";
            echo "</tbody></table>";
        } else {
            echo "<p>لا توجد زيارات لهذا التاريخ.</p>";
        }
        ?>

        <a href="javascript:history.back()" class="btn-back">رجوع إلى الصفحة السابقة</a>
    </div>
</body>
</html>

<?php
$conn->close();
?>
