<?php
session_start();
// الاتصال بقاعدة البيانات
include('admin_user_pass.php');

$conn = new mysqli($servername, $username, $password, $dbname);
date_default_timezone_set('Asia/Riyadh');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// التحقق من تقديم طلب مسح البيانات للصفحة الاولى
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_data'])) {
    $delete_sql = "DELETE FROM clicks";
    if ($conn->query($delete_sql) === TRUE) {
        // تخزين رسالة نجاح في الجلسة
        $_SESSION['delete_success'] = 'تم مسح جميع البيانات بنجاح.';
    } else {
        echo "<p style='text-align: center; color: red;'>حدث خطأ أثناء مسح البيانات: " . $conn->error . "</p>";
    }
    // إعادة تحميل الصفحة بعد عملية المسح
    header('Location: combined_report.php');
    exit;
}

// التحقق من تقديم طلب مسح البيانات للصفحة الثانية
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_data_visits'])) {
    $delete_sql = "DELETE FROM page_visits";
    if ($conn->query($delete_sql) === TRUE) {
        // تخزين رسالة نجاح في الجلسة
        $_SESSION['delete_success_visits'] = 'تم مسح جميع البيانات بنجاح.';
    } else {
        echo "<p style='text-align: center; color: red;'>حدث خطأ أثناء مسح البيانات: " . $conn->error . "</p>";
    }
    // إعادة تحميل الصفحة بعد عملية المسح
    header('Location: combined_report.php');
    exit;
}

// قيم الإدخال الافتراضية للصفحتين
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

// استعلام SQL لجلب البيانات للصفحة الأولى بناءً على الفترة الزمنية (التاريخ فقط)
$sql_first = "
    SELECT 
        button_type,
        DATE(click_time) AS click_date,
        COUNT(*) AS click_count
    FROM clicks
";
if ($start_date && $end_date) {
    $sql_first .= " WHERE DATE(click_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $sql_first .= " WHERE DATE(click_time) >= '$start_date'";
} elseif ($end_date) {
    $sql_first .= " WHERE DATE(click_time) <= '$end_date'";
}
$sql_first .= " GROUP BY button_type, click_date ORDER BY click_date ASC";

$result_first = $conn->query($sql_first);

// استعلام لحساب المجموع الكلي للنقرات
$sql_total_first = "
    SELECT COUNT(*) AS total_clicks 
    FROM clicks 
";


// استعلام cURL للحصول على محتوى title من الموقع الآخر
$url = $_SERVER['REQUEST_SCHEME'] . "://" . $_SERVER['HTTP_HOST'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
curl_setopt($ch, CURLOPT_HTTPHEADER, ["Accept-Language: ar"]);

$response = curl_exec($ch);
$curlError = curl_error($ch);
curl_close($ch);

if ($response === false) {
    echo "خطأ في جلب البيانات من الموقع: $url<br>cURL Error: $curlError<br>";
    exit;
}

if (strpos($response, "\x1f\x8b\x08") === 0) {
    $response = gzdecode($response);
}

$dom = new DOMDocument();
libxml_use_internal_errors(true);
$dom->loadHTML($response);
libxml_clear_errors();

$xpath = new DOMXPath($dom);
$titleNodes = $xpath->query("//title");
$titleContent = $titleNodes->length > 0 ? $titleNodes->item(0)->nodeValue : "";





if ($start_date && $end_date) {
    $sql_total_first .= " WHERE DATE(click_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $sql_total_first .= " WHERE DATE(click_time) >= '$start_date'";
} elseif ($end_date) {
    $sql_total_first .= " WHERE DATE(click_time) <= '$end_date'";
}
$result_total_first = $conn->query($sql_total_first);
$total_clicks = $result_total_first->fetch_assoc()['total_clicks'] ?? 0;

// استعلام SQL لجلب البيانات للصفحة الثانية بناءً على الفترة الزمنية
$sql_second = "
    SELECT 
        DATE(visit_time) AS visit_date, 
        COUNT(*) AS visit_count
    FROM page_visits
";



if ($start_date && $end_date) {
    $sql_second .= " WHERE DATE(visit_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $sql_second .= " WHERE DATE(visit_time) >= '$start_date'";
} elseif ($end_date) {
    $sql_second .= " WHERE DATE(visit_time) <= '$end_date'";
}
$sql_second .= " GROUP BY visit_date ORDER BY visit_date ASC";

$result_second = $conn->query($sql_second);



$sql_min = "
    SELECT MIN(visit_time) AS first_visit 
    FROM page_visits
";

if ($start_date && $end_date) {
    $sql_min .= " WHERE DATE(visit_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $sql_min .= " WHERE DATE(visit_time) >= '$start_date'";
} elseif ($end_date) {
    $sql_min .= " WHERE DATE(visit_time) <= '$end_date'";
}



// استعلام لحساب المجموع الكلي للزيارات
$sql_max = "
    SELECT MAX(visit_time) AS last_visit 
    FROM page_visits
";
if ($start_date && $end_date) {
    $sql_max .= " WHERE DATE(visit_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $sql_max .= " WHERE DATE(visit_time) >= '$start_date'";
} elseif ($end_date) {
    $sql_max .= " WHERE DATE(visit_time) <= '$end_date'";
}

$sql_total = "
    SELECT COUNT(*) AS total_visits 
    FROM page_visits
";
if ($start_date && $end_date) {
    $sql_total .= " WHERE DATE(visit_time) BETWEEN '$start_date' AND '$end_date'";
} elseif ($start_date) {
    $sql_total .= " WHERE DATE(visit_time) >= '$start_date'";
} elseif ($end_date) {
    $sql_total .= " WHERE DATE(visit_time) <= '$end_date'";
}
$result_total = $conn->query($sql_total);
$total_visits = $result_total->fetch_assoc()['total_visits'] ?? 0;





// تنفيذ الاستعلامات فقط إذا كانت التواريخ غير فارغة
if ($start_date || $end_date) {
    $sql_min = $conn->query($sql_min);
    $sql_max = $conn->query($sql_max);

    // استخراج التاريخ فقط
    $first_visit = $sql_min->fetch_assoc()['first_visit'] ?? '';
    $last_visit = $sql_max->fetch_assoc()['last_visit'] ?? '';

    // تحويل التاريخ إلى الصيغة المطلوبة (YYYY-MM-DD)
    $first_visit_date = $first_visit ? date('Y-m-d', strtotime($first_visit)) : 'غير موجود';
    $last_visit_date = $last_visit ? date('Y-m-d', strtotime($last_visit)) : 'غير موجود';
}


ob_start(); // بدء تخزين المخرجات في المخزن المؤقت
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['generate_pdf'])) {
        ob_clean();
    flush();
    // إذا لم يتم تعيين التواريخ، جلب أول وآخر زيارة من قاعدة البيانات
    if (empty($first_visit_date) || empty($last_visit_date)) {
        // استعلام لجلب أول زيارة من قاعدة البيانات
        $first_visit_sql = "SELECT MIN(visit_time) AS first_visit FROM page_visits";
        $first_visit_result = $conn->query($first_visit_sql);
        $first_visit = $first_visit_result->fetch_assoc()['first_visit'] ?? null;
        $first_visit_date = $first_visit ? date('Y-m-d', strtotime($first_visit)) : 'غير متوفر';

        // استعلام لجلب آخر زيارة من قاعدة البيانات
        $last_visit_sql = "SELECT MAX(visit_time) AS last_visit FROM page_visits";
        $last_visit_result = $conn->query($last_visit_sql);
        $last_visit = $last_visit_result->fetch_assoc()['last_visit'] ?? null;
        $last_visit_date = $last_visit ? date('Y-m-d', strtotime($last_visit)) : 'غير متوفر';
    }



    require_once('tcpdf/tcpdf.php');

    $pdf = new TCPDF();
    $pdf->SetFont('aealarabiya', '', 12);
    $pdf->SetRTL(true);
    $pdf->SetMargins(10, 20, 10);
    $pdf->AddPage();

    $pdf->SetFont('aealarabiya', 'B', 18);
    $pdf->Cell(0, 10, 'شركة منتشر', 0, 1, 'C');
    $pdf->SetFont('aealarabiya', 'B', 16);
    $pdf->Cell(0, 10, 'تقرير مفصل عن النقرات للموقع', 0, 1, 'C');
    $pdf->Ln(10);
    $pdf->SetFont('aealarabiya', 'B', 14);
    $pdf->Cell(0, 10, $titleContent, 0, 1, 'C');
    $pdf->Ln(10);

    // عرض تاريخ أول وآخر زيارة بناءً على نتائج قاعدة البيانات
    $pdf->SetFont('aealarabiya', 'B', 12);
    $pdf->Cell(0, 10, "من تاريخ: $first_visit_date", 0, 1, 'C');
    $pdf->Cell(0, 10, "الى تاريخ: $last_visit_date", 0, 1, 'C');
    $pdf->Ln(10);

    // عرض البيانات في التقرير
$pdf->SetTextColor(255, 255, 255);
$pdf->SetFillColor(0, 102, 204);
// ترتيب الأعمدة: التاريخ، عدد الزيارات، نوع الزر
$pdf->Cell(60, 10, 'التاريخ', 1, 0, 'C', 1);
$pdf->Cell(60, 10, 'عدد الزيارات', 1, 0, 'C', 1);
$pdf->Cell(60, 10, 'نوع الزر', 1, 1, 'C', 1);

$pdf->SetTextColor(0, 0, 0);
if ($result_first->num_rows > 0) {
    while ($row = $result_first->fetch_assoc()) {
        $pdf->Cell(60, 10, $row['click_date'], 1, 0, 'C');   // التاريخ أولاً
        $pdf->Cell(60, 10, $row['click_count'], 1, 0, 'C');  // عدد الزيارات ثانياً
        $pdf->Cell(60, 10, $row['button_type'], 1, 1, 'C');  // نوع الزر أخيراً
    }
} else {
    $pdf->Cell(180, 10, 'لا يوجد بيانات', 1, 1, 'C');
}
    $pdf->Ln(10);
    $pdf->SetFont('aealarabiya', 'B', 12);
    $pdf->SetTextColor(255, 0, 0);
    $pdf->Cell(0, 10, 'إجمالي النقرات: ' . $total_clicks, 0, 1, 'C');

    $image_path = 'image/logo-w.png';
    $pdf->SetY(-50);
    $pdf->Image($image_path, ($pdf->getPageWidth() - 50) / 2, $pdf->GetY(), 50, 0, 'PNG');
    
        $pdf->SetFont('aealarabiya', '', 12);
    $pdf->SetRTL(true);
    $pdf->SetMargins(10, 20, 10);
    $pdf->AddPage();

    $pdf->SetFont('aealarabiya', 'B', 18);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->Cell(0, 10, 'شركة منتشر', 0, 1, 'C');
    $pdf->SetFont('aealarabiya', 'B', 16);
    $pdf->Cell(0, 10, 'تقرير مفصل عن النقرات للموقع', 0, 1, 'C');
    $pdf->Ln(10);
    $pdf->SetFont('aealarabiya', 'B', 14);
    $pdf->Cell(0, 10, $titleContent, 0, 1, 'C');
    $pdf->Ln(10);



    // عرض البيانات في التقرير
    $pdf->SetTextColor(255, 255, 255);
    $pdf->SetFillColor(0, 102, 204);
    $pdf->Cell(90, 10, 'التاريخ', 1, 0, 'C', 1);
    $pdf->Cell(90, 10, 'عدد الزيارات', 1, 1, 'C', 1);

    $pdf->SetTextColor(0, 0, 0);
    if ($result_second->num_rows > 0) {
        while ($row = $result_second->fetch_assoc()) {
            $pdf->Cell(90, 10, $row['visit_date'], 1, 0, 'C');
            $pdf->Cell(90, 10, $row['visit_count'], 1, 1, 'C');
        }
    } else {
        $pdf->Cell(180, 10, 'لا يوجد بيانات', 1, 1, 'C');
    }

    $pdf->Ln(10);
    $pdf->SetFont('aealarabiya', 'B', 12);
    $pdf->SetTextColor(255, 0, 0);
    $pdf->Cell(0, 10, 'إجمالي الزيارات: ' . $total_visits, 0, 1, 'C');

    $image_path = 'image/logo-w.png';
    $pdf->SetY(-50);
    $pdf->Image($image_path, ($pdf->getPageWidth() - 50) / 2, $pdf->GetY(), 50, 0, 'PNG');

    $pdf->Output('report.pdf', 'I');
    exit;
}
?>





<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إحصائيات النقرات و الزيارات</title>
    <link rel="stylesheet" href="css/styles.css"> <!-- رابط ملف CSS -->
    <style>
        /* إضافة بعض الأنماط للزر عند تعطيله */
        button:disabled {
            background-color: #ccc;
            cursor: not-allowed;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>إحصائيات النقرات والزيارات</h1>

        <!-- نموذج إدخال التاريخ -->
        <form method="GET">
            <label for="start_date">من:</label>
            <input type="date" name="start_date" id="start_date" value="<?php echo htmlspecialchars($start_date ?: $first_visit_date); ?>">
            <label for="end_date">إلى:</label>
            <input type="date" name="end_date" id="end_date" value="<?php echo htmlspecialchars($end_date ?: $last_visit_date); ?>">            
            <button type="submit" id="filter-btn" disabled>فلترة</button>
        </form>

 <!-- زر توليد تقرير PDF -->
        <form method="post">
            <button type="submit" id="generate-pdf-btn" name="generate_pdf" disabled>توليد تقرير PDF</button>
        </form>

        <script>
            // الجافا سكربت لتفعيل الأزرار عند تحديد التاريخين
            document.addEventListener('DOMContentLoaded', function () {
                const startDateInput = document.getElementById('start_date');
                const endDateInput = document.getElementById('end_date');
                const filterButton = document.getElementById('filter-btn');
                const generatePdfButton = document.getElementById('generate-pdf-btn');

                function checkDates() {
                    // تفعيل الأزرار إذا كانت التواريخ موجودة
                    if (startDateInput.value && endDateInput.value) {
                        filterButton.disabled = false;
                        generatePdfButton.disabled = false;  // تفعيل زر توليد PDF
                    } else {
                        filterButton.disabled = true;
                        generatePdfButton.disabled = true;  // تعطيل زر توليد PDF
                    }
                }

                startDateInput.addEventListener('change', checkDates);
                endDateInput.addEventListener('change', checkDates);

                // تحقق عند تحميل الصفحة
                checkDates();
            });
        </script>
        <p><h1><?php echo htmlspecialchars($titleContent); ?></h1></p>

<hr>

        <h2>إحصائيات النقرات</h2>
        <!-- عرض البيانات في جدول للصفحة الأولى -->
        <table>
            <thead>
                <tr>
                    <th>نوع الزر</th>
                    <th>التاريخ</th>
                    <th>عدد النقرات</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result_first->num_rows > 0) {
                    while ($row = $result_first->fetch_assoc()) {
                        echo "<tr>
                                <td>" . htmlspecialchars($row['button_type']) . "</td>
                                <td><a href='daily_clicks.php?date=" . htmlspecialchars($row['click_date']) . "&button_type=" . htmlspecialchars($row['button_type']) . "'>" . htmlspecialchars($row['click_date']) . "</a></td>                                <td>" . htmlspecialchars($row['click_count']) . "</td>
                              </tr>";
                    }
                } else {
                    echo "<tr><td colspan='3'>لا توجد بيانات</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <p><strong>إجمالي النقرات: <?php echo $total_clicks; ?></strong></p>
                <!-- زر مسح البيانات للصفحة الأولى -->
        <form method="post">
            <button type="submit" name="delete_data">مسح بيانات النقرات</button>
        </form>
<hr>
        <h2>إحصائيات الزيارات</h2>


        <!-- عرض البيانات في جدول للصفحة الثانية -->
        <table>
            <thead>
                <tr>
                    <th>التاريخ</th>
                    <th>عدد الزيارات</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result_second->num_rows > 0) {
                    while ($row = $result_second->fetch_assoc()) {
                        echo "<tr>
                                <td><a href='daily_visits.php?date=" . htmlspecialchars($row['visit_date']) . "'>" . htmlspecialchars($row['visit_date']) . "</a></td>
                                <td>" . htmlspecialchars($row['visit_count']) . "</td>
                              </tr>";
                    }
                } else {
                    echo "<tr><td colspan='2'>لا توجد بيانات</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <p><strong>إجمالي الزيارات: <?php echo $total_visits; ?></strong></p>
                <!-- زر مسح البيانات للصفحة الثانية -->
        <form method="post">
            <button type="submit" name="delete_data_visits">مسح بيانات الزيارات</button>
        </form>
    </div>

    <script>
        // الجافا سكربت لتفعيل الأزرار عند تحديد التاريخين
        document.addEventListener('DOMContentLoaded', function () {
            const startDateInput = document.getElementById('start_date');
            const endDateInput = document.getElementById('end_date');
            const filterButton = document.getElementById('filter-btn');

            function checkDates() {
                // تفعيل الأزرار إذا كانت التواريخ موجودة
                if (startDateInput.value && endDateInput.value) {
                    filterButton.disabled = false;
                } else {
                    filterButton.disabled = true;
                }
            }

            startDateInput.addEventListener('change', checkDates);
            endDateInput.addEventListener('change', checkDates);

            // تحقق عند تحميل الصفحة
            checkDates();
        });
    </script>
        <script>
    // تحقق من وجود رسالة في الجلسة لعرض رسالة JavaScript
    <?php if (isset($_SESSION['delete_success'])): ?>
        alert('<?php echo $_SESSION['delete_success']; ?>');
        // مسح الرسالة بعد عرضها لمنع تكرارها في المرات القادمة
        <?php unset($_SESSION['delete_success']); ?>
    <?php endif; ?>
</script>

        <script>
    // تحقق من وجود رسالة في الجلسة لعرض رسالة JavaScript
    <?php if (isset($_SESSION['delete_success_visits'])): ?>
        alert('<?php echo $_SESSION['delete_success_visits']; ?>');
        // مسح الرسالة بعد عرضها لمنع تكرارها في المرات القادمة
        <?php unset($_SESSION['delete_success_visits']); ?>
    <?php endif; ?>
</script>
</body>
</html>

<?php
$conn->close();
?>